/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cmsc420project4;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

/**
 *
 * @author Jeremiah
 */
public class DirectedGraph {
    ArrayList<DirectedNode> nodes;

    DirectedGraph()
            {
        nodes = new ArrayList<DirectedNode>();
    }

   //
    public void addNode(DirectedNode node)
            {
            nodes.add(node);
        }

    public void removeNode(DirectedNode node)
            {
        int currentNode = nodes.indexOf(node);
        for(int x=0; x<nodes.size(); x++)
            {
            if(x!= currentNode)
                {
                nodes.get(x).removeInNode(node);
            }
        }
        nodes.remove(node);
        }

    public Queue<DirectedNode> getSortedNodes() throws CycleFoundException
            {

        // Topological sort

        System.out.println("# of nodes before sort: " + nodes.size());

        // Reset nodes for the sort
        for(int x=0; x<nodes.size(); x++)
            {
            nodes.get(x).resetTopoNum();
            System.out.println("Reset " + x);
        }

        Queue<DirectedNode> sortedNodes = new LinkedList<DirectedNode>();

        // Find indegree of all nodes
        // Oddly enough, LinkedList is a type of Queue in Java.
        Queue<DirectedNode> zeroDegrees = new LinkedList();

        for(int x=0; x<nodes.size(); x++)
            {
            if(nodes.get(x).getInDegree()==0)
                {
                zeroDegrees.add(nodes.get(x));
            //sortedNodes.add(nodes.get(x));
            System.out.println("Add " + x);
            }
        }


        int counter = 0;

        while(!zeroDegrees.isEmpty())
            {
            System.out.println("Remove " + counter);
            DirectedNode tempNode = zeroDegrees.remove();
            sortedNodes.add(tempNode);
            counter++;
            System.out.println("Nodes size = " + nodes.size());
            for(int x=0; x<nodes.size(); x++)
                {
                if(tempNode.isIn(nodes.get(x)) && tempNode.getTopoNum()>0)
                    {
                    tempNode.decrementTopoNum();
                    if(tempNode.getTopoNum()==0)
                        {
                        zeroDegrees.add(tempNode);
                        System.out.println("add " + x);
                    }
                }
            }
            
        }
        
        if(counter != nodes.size())
            {
            throw new CycleFoundException();
        }

        System.out.println("# of nodes after sort: " + sortedNodes.size());

        //return zeroDegrees;
        return sortedNodes;
    }
}
